<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Common;

use Erlage\Photogram\Tools\Crypto;
use Erlage\Photogram\Reflection\TraitReflectionClassName;

final class CommonTransformer
{
    use TraitReflectionClassName;

    public static function metaAccessOTP(string $metaAccessOTP): string
    {
        if (empty($metaAccessOTP))
        {
            // generate random otp(code)
            return Crypto::randomOTP(32);
        }

        return $metaAccessOTP;
    }

    public static function metaAccessToken(string $metaAccessToken): string
    {
        if (empty($metaAccessToken))
        {
            // generate random token
            return Crypto::randomString(32);
        }

        return $metaAccessToken;
    }
}
